<?php

namespace Symfony\Component\Console\Helper;

/*
 * This file is part of the symfony framework.
 *
 * (c) Fabien Potencier <fabien.potencier@symfony-project.com>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */

/**
 * Helper is the base class for all helper classes.
 *
 * @package    symfony
 * @subpackage console
 * @author     Fabien Potencier <fabien.potencier@symfony-project.com>
 */
abstract class Helper implements HelperInterface
{
  protected
    $helperSet = null;

  /**
   * Sets the helper set associated with this helper.
   *
   * @param HelperSet $helperSet A HelperSet instance
   */
  public function setHelperSet(HelperSet $helperSet = null)
  {
    $this->helperSet = $helperSet;
  }

  /**
   * Gets the helper set associated with this helper.
   *
   * @return HelperSet A HelperSet instance
   */
  public function getHelperSet()
  {
    return $this->helperSet;
  }
}
